#pragma rtGlobals=1		// Use modern global access method.

//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------

Window FilterGraph() : graph
	silent 1;  PauseUpdate;
	Display /W=(18,43,312,366)/L=Y_Top/B=X_top Hist_t_elec,Hist_t_ions as "Filtered Event Graph"
	AppendImage x_ions_y_ions
	ModifyImage x_ions_y_ions ctab= {*,*,Rainbow,1}
	AppendImage/B=X_Elec x_elec_y_elec
	ModifyImage x_elec_y_elec ctab= {*,*,Rainbow,1}
	ModifyGraph width={Aspect,1}
	ModifyGraph rgb(Hist_t_elec)=(0,0,0)
	ModifyGraph mirror(left)=0,mirror(bottom)=0
	ModifyGraph lblPos(Y_Top)=31,lblPos(left)=43,lblPos(bottom)=37
	ModifyGraph lblLatPos(Y_Top)=-2
	ModifyGraph freePos(Y_Top)={0,X_top}
	ModifyGraph freePos(X_top)={0,Y_Top}
	ModifyGraph freePos(X_Elec)={64,left}
	ModifyGraph axisEnab(Y_Top)={0.6,1}
	ModifyGraph axisEnab(left)={0,0.45}
	ModifyGraph axisEnab(bottom)={0,0.45}
	ModifyGraph axisEnab(X_Elec)={0.55,1}
	SetAxis/A/N=1/E=1 Y_Top
	SetAxis/A/R left
	TextBox/N=text0/F=0/A=MC/X=37.29/Y=36.47 "\\s(Hist_t_elec) Electron\r\\s(Hist_t_ions) Ion"
	ControlBar 45
	ValDisplay Ion,pos={88,26},size={117,15},title="Ions",value= root:PreTreatmentParam:counts_i
	ValDisplay Elec,pos={63,6},size={142,15},title="Electrons",value= root:PreTreatmentParam:counts_e
	SetDrawLayer UserFront
	SetDrawEnv xcoord= bottom,ycoord= left,fillpat= 0
	DrawOval 1,1,64,64
	SetDrawEnv xcoord= X_Elec,ycoord= left,fillpat= 0
	DrawOval 1,1,64,64
	SetDrawEnv xcoord= bottom,ycoord= left
	DrawLine 32,0,32,64
	SetDrawEnv xcoord= X_Elec,ycoord= left
	DrawLine 32,0,32,64
	SetDrawEnv xcoord= bottom,ycoord= left
	DrawLine 0,32,64,32
	SetDrawEnv xcoord= X_Elec,ycoord= left
	DrawLine 0,32,64,32
EndMacro

//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------

Proc FetchGraph(particle) : Graph
	string particle
	PauseUpdate; Silent 1		// building window...
	Display /W=(12,51,503,521) as "Fetch Event Graph"
	DoWindow/C/N $("FetchGraph"+particle)
	AppendImage $("x_"+particle+"_y_"+particle)
	ModifyImage $("x_"+particle+"_y_"+particle) ctab= {*,*,Rainbow,1}
	ModifyGraph width={Aspect,1},height={Aspect,1}
	ModifyGraph mirror=2
	SetAxis/A/R left
	SetDrawLayer UserFront
	SetDrawEnv xcoord= bottom,ycoord= left
	DrawLine 0,-32,0,32
	SetDrawEnv xcoord= bottom,ycoord= left
	DrawLine -32,0,32,0

	SetDrawEnv xcoord= bottom,ycoord= left,fillpat= 0
	DrawOval -5,-5,5,5
	SetDrawEnv xcoord= bottom,ycoord= left,fillpat= 0
	DrawOval -10,-10,10,10
	SetDrawEnv xcoord= bottom,ycoord= left,fillpat= 0
	DrawOval -15,-15,15,15
	SetDrawEnv xcoord= bottom,ycoord= left,fillpat= 0
	DrawOval -20,-20,20,20
	SetDrawEnv xcoord= bottom,ycoord= left,fillpat= 0
	DrawOval -25,-25,25,25
	SetDrawEnv xcoord= bottom,ycoord= left,fillpat= 0
	DrawOval -30,-30,30,30

EndMacro